IF EXISTS ( SELECT * FROM SYS.OBJECTS 
	WHERE NAME = 'P_CONCILIADOR_LINX_CARTAO_FILIAL')
BEGIN 
	DROP PROCEDURE P_CONCILIADOR_LINX_CARTAO_FILIAL
END
GO

CREATE PROCEDURE [dbo].[P_CONCILIADOR_LINX_CARTAO_FILIAL]  (@CD_EMP_PROC INT,  @CD_FILIAL_PROC INT, @DT_MOV DATE) 
AS 
DECLARE @CD_EMP			INT 
DECLARE @CD_FILIAL		INT 
DECLARE @CD_VD			INT 
DECLARE @CD_CTR			BIGINT 
DECLARE @TIPO			VARCHAR(20)
DECLARE @CD_RECTO_TEF	INT
DECLARE @CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF INT
	CREATE TABLE #PENDENTE_CONCILIACAO (CD_EMP INT, CD_FILIAL INT , CD_VD INT, CD_CTR BIGINT , CD_RECTO_TEF  INT , CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF INT, TIPO VARCHAR(20) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS );
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	PRINT 'Capturando periodo pendente.: '+ CONVERT(VARCHAR, GETDATE(), 120);
	INSERT INTO #PENDENTE_CONCILIACAO
	SELECT PDV_VD_TEF_PEND.CD_EMP		AS CD_EMP ,
		   PDV_VD_TEF_PEND.CD_FILIAL	AS CD_FILIAL,
		   PDV_VD_TEF_PEND.CD_VD		AS CD_VD,
		   PDV_VD_TEF_PEND.CD_CTR		AS CD_CTR,
		   0							AS CD_RECTO_TEF,
		   0							AS CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF,
		   'CUPOM_FISCAL'  				AS TIPO
      FROM PDV_VD_TEF_PEND INNER JOIN PDV_VD ON 
		  PDV_VD_TEF_PEND.CD_EMP = PDV_VD.CD_EMP
		  AND PDV_VD_TEF_PEND.CD_FILIAL = PDV_VD.CD_FILIAL
		  AND PDV_VD_TEF_PEND.CD_VD = PDV_VD.CD_VD
	 WHERE PDV_VD.CD_EMP = @CD_EMP_PROC 
		  AND PDV_VD.CD_FILIAL=@CD_FILIAL_PROC
		  AND CONVERT(DATE,PDV_VD.DT_VD)=@DT_MOV
    UNION ALL 
	SELECT PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP										AS CD_EMP ,
		   PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL									AS CD_FILIAL,
		   PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO										AS CD_VD,
		   PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR										AS CD_CTR,
		   ISNULL(PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_RECTO_TEF,0)						AS CD_RECTO_TEF,
		   ISNULL(PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR,0)	AS CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF,
		   'NAO_FISCAL'																AS TIPO
      FROM 
		  PDV_CUPOM_NAO_FISCAL_TEF_PEND  INNER JOIN PDV_CUPOM_NAO_FISCAL ON 
		  PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP  = PDV_CUPOM_NAO_FISCAL.CD_EMP
		  AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL  = PDV_CUPOM_NAO_FISCAL.CD_FILIAL
		  AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR  = PDV_CUPOM_NAO_FISCAL.CD_CTR
	 WHERE 
		  PDV_CUPOM_NAO_FISCAL.CD_EMP = @CD_EMP_PROC 
		  AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL=@CD_FILIAL_PROC
		  AND CONVERT(DATE,PDV_CUPOM_NAO_FISCAL.DT_CUPOM)=@DT_MOV
IF NOT EXISTS (SELECT TOP 1 * FROM #PENDENTE_CONCILIACAO )			 
BEGIN 
	PRINT 'No existe perioro pendente.:' ;
	RETURN ;
END 
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	DECLARE CONCILIADORLINX CURSOR  
	FOR 
		SELECT CD_EMP, 
			   CD_FILIAL, 
			   CD_VD, 
			   CD_CTR, 
			   CD_RECTO_TEF, 
			   CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF,
			   TIPO
		  FROM #PENDENTE_CONCILIACAO  PEND
	OPEN CONCILIADORLINX;
	FETCH NEXT FROM CONCILIADORLINX INTO @CD_EMP, @CD_FILIAL, @CD_VD, @CD_CTR, @CD_RECTO_TEF, @CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF,  @TIPO;
	WHILE @@FETCH_STATUS = 0
	BEGIN
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	IF EXISTS (SELECT TOP 1 * FROM #PENDENTE_CONCILIACAO WHERE CD_EMP  = 1 AND CD_FILIAL = @CD_FILIAL AND CD_VD =  @CD_VD  AND CD_CTR = @CD_CTR AND @TIPO = 'CUPOM_FISCAL' )
	BEGIN
		PRINT 'PROCESSANDO CUPOM FISCAL. 
			   CD_FILIAL.: ' + CONVERT(VARCHAR, @CD_FILIAL) + 
			   ' CD_VD.: '   + CONVERT(VARCHAR, @CD_VD)  + 
			   ' CD_CTR.: '   + CONVERT(VARCHAR, @CD_CTR);
		 	INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
														)
			SELECT 
					 PDV_VD.CD_EMP					AS CD_EMP				
					,PDV_VD.CD_FILIAL				AS CD_FILIAL			
					,PDV_VD.CD_CX					AS CD_CX				
					,PDV_VD.NR_ECF					AS NR_ECF				
					,PDV_VD.DT_VD					AS DT_VD				
					,PDV_VD_TEF.VL_CARTAO			AS VLR_VENDA			
					,CONCILIADOR.ST_LOJA			AS COD_SIT				
					,PDV_VD_TEF.CD_ADM_CARTAO		AS IDT_REDE			
					,PDV_VD_TEF.NM_OPERADORA_PDV    AS DESCR_REDE			
					,BANDEIRA.CD_BANDEIRA			AS IDT_PRODUTO			
					,BANDEIRA.TX_DESCRICAO			AS DESCR_PRODUTO		
					,0								AS DESCR_TRN			
					,BANDEIRA.CD_BANDEIRA			AS IDT_BANDEIRA		
					,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA		
					,PDV_VD_TEF.QTDE_PARCELAS		AS NUM_PARCELAS		
					,''								AS CODIGO_RESP			
					,0								AS ESTADO_TRN			
					,''								AS DATA_LANC			
					,''								AS DATAFISCAL			
					,CONCILIADOR.CD_AUTORIZACAO		AS COD_AUTORIZ			
					,PDV_VD.ST_VD					AS ST_VENDA			
				 	,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_VD_TEF.NSU_SITEF))			AS NSU_SITEF			
					,1								AS TP_OP_AUTOMATICO	
					,PDV_VD_TEF.CD_CTR
					,PDV_VD_TEF.CD_VD
					,CONCILIADOR.IDT_TRANSACAO
					,CONCILIADOR.CD_CTR
					,0								AS CD_RECTO_TEF
					,0								AS CD_CTR
			  FROM PDV_VD 
				    JOIN PDV_VD_TEF ON PDV_VD.CD_EMP    = PDV_VD_TEF.CD_EMP   
								   AND PDV_VD.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
								   AND PDV_VD.CD_VD	    = PDV_VD_TEF.CD_VD
					JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR CONCILIADOR ON PDV_VD_TEF.CD_FILIAL = CONCILIADOR.CD_FILIAL
																		 AND (( CONVERT(VARCHAR,PDV_VD_TEF.NSU_SITEF)  = CONVERT(VARCHAR,CONCILIADOR.NSU_REDE) AND CONCILIADOR.NSU_REDE <> '0') OR 
																			    PDV_VD_TEF.NR_AUTORIZACAO COLLATE database_Default = CONCILIADOR.CD_AUTORIZACAO  COLLATE database_Default ) 
																		 AND (PDV_VD_TEF.QTDE_PARCELAS 	   = CONCILIADOR.NR_PARCELAS_REDE)
																	     AND (PDV_VD_TEF.VL_CARTAO = CONCILIADOR.VLR_BRUTO_REDE)
															 AND CONVERT(DATE,PDV_VD_TEF.DT_VD_ADM)=CONVERT(DATE,CONCILIADOR.DT_VENDA)
		LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON CONCILIADOR.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA 
		  LEFT JOIN V_EQUALS_FINAL  FINAL ON PDV_VD_TEF.CD_EMP		= FINAL.CD_EMP		
												    AND PDV_VD_TEF.CD_FILIAL	= FINAL.CD_FILIAL	
												    AND PDV_VD_TEF.CD_VD		= FINAL.CD_VD		
												    AND PDV_VD_TEF.CD_CTR		= FINAL.CD_CTR_PDV_VD_TEF
												    AND PDV_VD.DT_VD	= FINAL.DT_VD
			  WHERE PDV_VD_TEF.CD_EMP	 = @CD_EMP 
			    AND PDV_VD_TEF.CD_FILIAL = @CD_FILIAL
			 	AND PDV_VD_TEF.CD_VD     = @CD_VD
				AND PDV_VD_TEF.CD_CTR    = @CD_CTR
				AND FINAL.CD_EMP IS NULL 
				AND CONCILIADOR.TPT_REGISTRO = 3 
				AND CONCILIADOR.CD_GRUPO NOT IN (141,142,143)
				AND NOT CONCILIADOR.ST_LOJA IN (90,91)
				AND PDV_VD.ST_VD = 0
				AND NOT EXISTS (SELECT 1 
								FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP DEV
								INNER JOIN PDV_VD_DEV_NCC NCC ON DEV.CD_EMP = NCC.CD_EMP
								AND DEV.CD_FILIAL = NCC.CD_FILIAL
								AND DEV.CD_CTR_NCC = NCC.CD_CTR_NCC
								WHERE DEV.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
									  AND DEV.CD_VD = PDV_VD_TEF.CD_VD
									  AND STS_NCC IN (2,3,5)
									  AND NOT EXISTS (SELECT CD_EMP 
													  FROM RC_DEB_PDV_VD_DEV_NCC DEB
													  WHERE DEV.CD_EMP = DEB.CD_EMP AND DEV.CD_FILIAL = DEB.CD_FILIAL
													  AND DEV.CD_CTR_NCC = DEB.CD_CTR_NCC)
									  AND ((SELECT COUNT(DISTINCT V_IT.CD_PROD) 
											FROM V_PDV_VD_IT V_IT 
											WHERE V_IT.CD_VD = DEV.CD_FILIAL 
											AND V_IT.CD_FILIAL = DEV.CD_FILIAL
											AND V_IT.CD_EMP = 1) = (SELECT COUNT(DISTINCT IMP2.CD_PROD)
																					 FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP IMP2
																					 WHERE IMP2.CD_VD = DEV.CD_FILIAL
																					 AND IMP2.CD_FILIAL = DEV.CD_FILIAL)) /*DEVOLUÇÃO TOTAL*/
								) /*FARMAGOI-48262*/

				/*CARTEIRAS DIGITAIS*/
				INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												   ,CD_CTR_ID_QR_LINX
														)
			SELECT 
					 v.CD_EMP					AS CD_EMP				
					,v.CD_FILIAL				AS CD_FILIAL			
					,v.CD_CX					AS CD_CX				
					,v.NR_ECF					AS NR_ECF				
					,v.DT_VD					AS DT_VD				
					,PDV_VD_TEF.VL_CARTAO			AS VLR_VENDA			
					,c.ST_LOJA			AS COD_SIT				
					,PDV_VD_TEF.CD_ADM_CARTAO		AS IDT_REDE			
					,PDV_VD_TEF.NM_OPERADORA_PDV    AS DESCR_REDE			
					,BANDEIRA.CD_BANDEIRA			AS IDT_PRODUTO			
					,BANDEIRA.TX_DESCRICAO			AS DESCR_PRODUTO		
					,0								AS DESCR_TRN			
					,BANDEIRA.CD_BANDEIRA			AS IDT_BANDEIRA		
					,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA		
					,PDV_VD_TEF.QTDE_PARCELAS		AS NUM_PARCELAS		
					,''								AS CODIGO_RESP			
					,0								AS ESTADO_TRN			
					,''								AS DATA_LANC			
					,''								AS DATAFISCAL			
					,c.CD_AUTORIZACAO		AS COD_AUTORIZ			
					,v.ST_VD					AS ST_VENDA			
				 	,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_VD_TEF.NSU_SITEF))			AS NSU_SITEF			
					,1								AS TP_OP_AUTOMATICO	
					,PDV_VD_TEF.CD_CTR
					,PDV_VD_TEF.CD_VD
					,c.IDT_TRANSACAO
					,c.CD_CTR
					,0								AS CD_RECTO_TEF
					,0								AS CD_CTR
					,qr.CD_CTR_ID AS CD_CTR_ID_QR_LINX
			from CONCILIACAO_CARTOES_LINX_CONCILIADOR c
			inner join PDV_NSU_QR_LINX qr on c.cd_autorizacao COLLATE DATABASE_DEFAULT = qr.id_transaction COLLATE DATABASE_DEFAULT
											and c.cd_filial = qr.cd_filial
											and c.vlr_bruto_rede = qr.vlr_qr_linx
			INNER JOIN PDV_VD_PDV_NSU_QR_LINX  nsu2 on nsu2.CD_CTR_ID = qr.CD_CTR_ID
			INNER JOIN pdv_vd V ON V.CD_EMP = 1 AND V.CD_FILIAL = QR.CD_FILIAL AND nsu2.cd_vd = V.cd_vd
			JOIN PDV_VD_TEF ON v.CD_EMP    = PDV_VD_TEF.CD_EMP   
								AND v.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
								AND v.CD_VD	    = PDV_VD_TEF.CD_VD
								AND PDV_VD_TEF.VL_CARTAO = QR.VLR_QR_LINX
			LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON c.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA 
			LEFT JOIN V_EQUALS_FINAL  FINAL ON PDV_VD_TEF.CD_EMP		= FINAL.CD_EMP		
																AND PDV_VD_TEF.CD_FILIAL	= FINAL.CD_FILIAL	
																AND PDV_VD_TEF.CD_VD		= FINAL.CD_VD		
																AND PDV_VD_TEF.CD_CTR		= FINAL.CD_CTR_PDV_VD_TEF
																AND V.DT_VD	= FINAL.DT_VD
			WHERE 
			PDV_VD_TEF.CD_EMP	 = @CD_EMP 
			AND PDV_VD_TEF.CD_FILIAL = @CD_FILIAL
			AND PDV_VD_TEF.CD_VD     = @CD_VD
			AND PDV_VD_TEF.CD_CTR    = @CD_CTR
			AND FINAL.CD_EMP IS NULL 
			AND c.TPT_REGISTRO = 3 
			AND c.CD_GRUPO NOT IN (141,142,143)
			AND NOT c.ST_LOJA IN (90,91)
			AND v.ST_VD = 0
			AND QR.NOME_CARTEIRA NOT LIKE '%PIX%'
			AND NOT EXISTS (SELECT 1 
								FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP DEV
								INNER JOIN PDV_VD_DEV_NCC NCC ON DEV.CD_EMP = NCC.CD_EMP
								AND DEV.CD_FILIAL = NCC.CD_FILIAL
								AND DEV.CD_CTR_NCC = NCC.CD_CTR_NCC
								WHERE DEV.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
									  AND DEV.CD_VD = PDV_VD_TEF.CD_VD
									  AND STS_NCC IN (2,3,5)
									  AND NOT EXISTS (SELECT CD_EMP 
													  FROM RC_DEB_PDV_VD_DEV_NCC DEB
													  WHERE DEV.CD_EMP = DEB.CD_EMP AND DEV.CD_FILIAL = DEB.CD_FILIAL
													  AND DEV.CD_CTR_NCC = DEB.CD_CTR_NCC)
									  AND ((SELECT COUNT(DISTINCT V_IT.CD_PROD) 
											FROM V_PDV_VD_IT V_IT 
											WHERE V_IT.CD_VD = DEV.CD_FILIAL 
											AND V_IT.CD_FILIAL = DEV.CD_FILIAL
											AND V_IT.CD_EMP = 1) = (SELECT COUNT(DISTINCT IMP2.CD_PROD)
																					 FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP IMP2
																					 WHERE IMP2.CD_VD = DEV.CD_FILIAL
																					 AND IMP2.CD_FILIAL = DEV.CD_FILIAL)) /*DEVOLUÇÃO TOTAL*/
								) /*FARMAGOI-48262*/

			/*FIM CARTEIRAS DIGITAIS - CUPOM FISCAL*/
			/*PIX*/
				INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												   ,CD_CTR_ID_QR_LINX
														)
			SELECT 
					 v.CD_EMP					AS CD_EMP				
					,v.CD_FILIAL				AS CD_FILIAL			
					,v.CD_CX					AS CD_CX				
					,v.NR_ECF					AS NR_ECF				
					,v.DT_VD					AS DT_VD				
					,PDV_VD_TEF.VL_CARTAO			AS VLR_VENDA			
					,c.ST_LOJA			AS COD_SIT				
					,PDV_VD_TEF.CD_ADM_CARTAO		AS IDT_REDE			
					,PDV_VD_TEF.NM_OPERADORA_PDV    AS DESCR_REDE			
					,BANDEIRA.CD_BANDEIRA			AS IDT_PRODUTO			
					,BANDEIRA.TX_DESCRICAO			AS DESCR_PRODUTO		
					,0								AS DESCR_TRN			
					,BANDEIRA.CD_BANDEIRA			AS IDT_BANDEIRA		
					,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA		
					,PDV_VD_TEF.QTDE_PARCELAS		AS NUM_PARCELAS		
					,''								AS CODIGO_RESP			
					,0								AS ESTADO_TRN			
					,''								AS DATA_LANC			
					,''								AS DATAFISCAL			
					,c.CD_AUTORIZACAO		AS COD_AUTORIZ			
					,v.ST_VD					AS ST_VENDA			
				 	,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_VD_TEF.NSU_SITEF))			AS NSU_SITEF			
					,1								AS TP_OP_AUTOMATICO	
					,PDV_VD_TEF.CD_CTR
					,PDV_VD_TEF.CD_VD
					,c.IDT_TRANSACAO
					,c.CD_CTR
					,0								AS CD_RECTO_TEF
					,0								AS CD_CTR
					,qr.CD_CTR_ID AS CD_CTR_ID_QR_LINX
			from CONCILIACAO_CARTOES_LINX_CONCILIADOR c
			inner join PDV_NSU_QR_LINX qr on c.NSU_REDE COLLATE DATABASE_DEFAULT = qr.id_payment COLLATE DATABASE_DEFAULT AND c.NSU_REDE <> '0'
											and c.cd_filial = qr.cd_filial
											and c.vlr_bruto_rede = qr.vlr_qr_linx
			INNER JOIN PDV_VD_PDV_NSU_QR_LINX  nsu2 on nsu2.CD_CTR_ID = qr.CD_CTR_ID
			INNER JOIN pdv_vd V ON V.CD_EMP = 1 AND V.CD_FILIAL = QR.CD_FILIAL AND nsu2.cd_vd = V.cd_vd
			JOIN PDV_VD_TEF ON v.CD_EMP    = PDV_VD_TEF.CD_EMP   
								AND v.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
								AND v.CD_VD	    = PDV_VD_TEF.CD_VD
								AND PDV_VD_TEF.VL_CARTAO = QR.VLR_QR_LINX /*iNCLUIDO EM 08/02 POR Problemas na Estrela*/
			LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON c.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA 
			LEFT JOIN V_EQUALS_FINAL  FINAL ON PDV_VD_TEF.CD_EMP		= FINAL.CD_EMP		
																AND PDV_VD_TEF.CD_FILIAL	= FINAL.CD_FILIAL	
																AND PDV_VD_TEF.CD_VD		= FINAL.CD_VD		
																AND PDV_VD_TEF.CD_CTR		= FINAL.CD_CTR_PDV_VD_TEF
																AND V.DT_VD	= FINAL.DT_VD
			WHERE 
			PDV_VD_TEF.CD_EMP	 = @CD_EMP 
			AND PDV_VD_TEF.CD_FILIAL = @CD_FILIAL
			AND PDV_VD_TEF.CD_VD     = @CD_VD
			AND PDV_VD_TEF.CD_CTR    = @CD_CTR
			AND FINAL.CD_EMP IS NULL 
			AND c.TPT_REGISTRO = 3 
			AND c.CD_GRUPO NOT IN (141,142,143)
			AND NOT c.ST_LOJA IN (90,91)
			AND v.ST_VD = 0
			AND QR.NOME_CARTEIRA LIKE '%PIX%'
			AND NOT EXISTS (SELECT 1 
								FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP DEV
								INNER JOIN PDV_VD_DEV_NCC NCC ON DEV.CD_EMP = NCC.CD_EMP
								AND DEV.CD_FILIAL = NCC.CD_FILIAL
								AND DEV.CD_CTR_NCC = NCC.CD_CTR_NCC
								WHERE DEV.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
									  AND DEV.CD_VD = PDV_VD_TEF.CD_VD
									  AND STS_NCC IN (2,3,5)
									  AND NOT EXISTS (SELECT CD_EMP 
													  FROM RC_DEB_PDV_VD_DEV_NCC DEB
													  WHERE DEV.CD_EMP = DEB.CD_EMP AND DEV.CD_FILIAL = DEB.CD_FILIAL
													  AND DEV.CD_CTR_NCC = DEB.CD_CTR_NCC)
									  AND ((SELECT COUNT(DISTINCT V_IT.CD_PROD) 
											FROM V_PDV_VD_IT V_IT 
											WHERE V_IT.CD_VD = DEV.CD_FILIAL 
											AND V_IT.CD_FILIAL = DEV.CD_FILIAL
											AND V_IT.CD_EMP = 1) = (SELECT COUNT(DISTINCT IMP2.CD_PROD)
																					 FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP IMP2
																					 WHERE IMP2.CD_VD = DEV.CD_FILIAL
																					 AND IMP2.CD_FILIAL = DEV.CD_FILIAL)) /*DEVOLUÇÃO TOTAL*/
								) /*FARMAGOI-48262*/

			/*FIM CARTEIRAS PIX - CUPOM FISCAL*/
			PRINT 'Atualizando IDT_TRANSACAO :'
			UPDATE PDV_VD_TEF
			   SET IDT_TRANSACAO = CONCILIACAO_CARTOES_FINAL.IDT_TRANSACAO
			  FROM PDV_VD_TEF
			       INNER JOIN CONCILIACAO_CARTOES_FINAL ON PDV_VD_TEF.CD_CTR = CONCILIACAO_CARTOES_FINAL.CD_CTR_PDV_VD_TEF 
												 AND PDV_VD_TEF.CD_VD  = CONCILIACAO_CARTOES_FINAL.CD_VD
												 AND PDV_VD_TEF.CD_FILIAL  = CONCILIACAO_CARTOES_FINAL.CD_FILIAL  
			 WHERE PDV_VD_TEF.CD_EMP	= @CD_EMP 
			   AND PDV_VD_TEF.CD_FILIAL	= @CD_FILIAL
			   AND PDV_VD_TEF.CD_VD		= @CD_VD
			   AND PDV_VD_TEF.CD_CTR	= @CD_CTR

			PRINT 'Removendo da pendencia.:'
			DELETE FROM PDV_VD_TEF_PEND
			   FROM PDV_VD_TEF  
			        INNER JOIN PDV_VD_TEF_PEND ON PDV_VD_TEF_PEND.CD_EMP	    = PDV_VD_TEF.CD_EMP	 
								        AND PDV_VD_TEF_PEND.CD_FILIAL	= PDV_VD_TEF.CD_FILIAL  
								        AND PDV_VD_TEF_PEND.CD_VD		= PDV_VD_TEF.CD_VD	 
								        AND PDV_VD_TEF_PEND.CD_CTR	    = PDV_VD_TEF.CD_CTR	 
					LEFT JOIN CONCILIACAO_CARTOES_FINAL  FINAL ON PDV_VD_TEF.CD_EMP		= FINAL.CD_EMP		
															  AND PDV_VD_TEF.CD_FILIAL	= FINAL.CD_FILIAL	
															  AND PDV_VD_TEF.CD_VD		= FINAL.CD_VD		
															  AND PDV_VD_TEF.CD_CTR		= FINAL.CD_CTR_PDV_VD_TEF
			  WHERE PDV_VD_TEF_PEND.CD_EMP	    = @CD_EMP 
				AND PDV_VD_TEF_PEND.CD_FILIAL	= @CD_FILIAL
				AND PDV_VD_TEF_PEND.CD_VD		= @CD_VD
				AND PDV_VD_TEF_PEND.CD_CTR	    = @CD_CTR	
	END
-- ==============================================================================================================================================================================	
	IF EXISTS (SELECT TOP 1 * FROM #PENDENTE_CONCILIACAO WHERE CD_EMP  = 1 AND CD_FILIAL = @CD_FILIAL AND CD_VD =  @CD_VD  AND CD_CTR = @CD_CTR AND @CD_RECTO_TEF > 0  AND @TIPO = 'NAO_FISCAL' )
	BEGIN 
		PRINT 'PROCESSANDO NAO FISCAL. 
			   CD_FILIAL.: ' + CONVERT(VARCHAR, @CD_FILIAL) + 
			   ' NR_COO.: '   + CONVERT(VARCHAR, @CD_VD)  + 
			   ' CD_CTR.: '   + CONVERT(VARCHAR, @CD_CTR);		
			INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												)	
		    SELECT 
					 PDV_CUPOM_NAO_FISCAL.CD_EMP				AS CD_EMP				
					,PDV_CUPOM_NAO_FISCAL.CD_FILIAL				AS CD_FILIAL			
					,PDV_CUPOM_NAO_FISCAL.CD_CX					AS CD_CX				
					,PDV_CUPOM_NAO_FISCAL.NR_COO				AS NR_ECF				
					,PDV_CUPOM_NAO_FISCAL.DT_CUPOM				AS DT_VD				
					,PDV_RECBTO_TEF.VL_CARTAO					AS VLR_VENDA			
					,CONCILIADOR.ST_LOJA					    AS COD_SIT				
					,PDV_RECBTO_TEF.CD_ADM_CARTAO			    AS IDT_REDE			
					,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_REDE			
					,PDV_RECBTO_TEF.COD_BANDEIRA			    AS IDT_PRODUTO			
					,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_PRODUTO		
					,0										    AS DESCR_TRN			
					,CONCILIADOR.CD_BANDEIRA_LOJA				AS IDT_BANDEIRA		
					,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA	
					,PDV_RECBTO_TEF.QTDE_PARCELAS				AS NUM_PARCELAS		
					,''											AS CODIGO_RESP			
					,0											AS ESTADO_TRN			
					,''											AS DATA_LANC			
					,''											AS DATAFISCAL			
					,CONCILIADOR.CD_AUTORIZACAO					AS COD_AUTORIZ			
					,PDV_CUPOM_NAO_FISCAL.ST_CUPOM				AS ST_VENDA			
				 	,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_RECBTO_TEF.NSU_SITEF))			AS NSU_SITEF			
					,1											AS TP_OP_AUTOMATICO	
					,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
					,PDV_CUPOM_NAO_FISCAL.NR_COO 
					,CONCILIADOR.IDT_TRANSACAO
					,CONCILIADOR.CD_CTR
					,PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF
					,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
						  FROM PDV_CUPOM_NAO_FISCAL 
				    JOIN PDV_CUPOM_NAO_FISCAL_TEF ON 
							PDV_CUPOM_NAO_FISCAL.CD_EMP		= PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
						AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
						AND PDV_CUPOM_NAO_FISCAL.CD_CTR		= PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
					JOIN PDV_RECBTO_TEF	 ON 
							PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
						AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
						AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF
					JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR CONCILIADOR ON 
							PDV_RECBTO_TEF.CD_FILIAL					= CONCILIADOR.CD_FILIAL
						AND (( CONVERT(VARCHAR,PDV_RECBTO_TEF.NSU_SITEF)	= CONVERT(VARCHAR,CONCILIADOR.NSU_REDE) AND CONCILIADOR.NSU_REDE <> '0') OR
						 PDV_RECBTO_TEF.NR_AUTORIZACAO		COLLATE database_Default		= CONCILIADOR.CD_AUTORIZACAO COLLATE database_Default)
						AND (PDV_RECBTO_TEF.QTDE_PARCELAS 				= CONCILIADOR.NR_PARCELAS_REDE)
					     AND (PDV_RECBTO_TEF.VL_CARTAO					= CONCILIADOR.VLR_BRUTO_REDE)
					LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON 
						CONCILIADOR.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA 
					LEFT JOIN V_EQUALS_FINAL  FINAL ON 
							PDV_CUPOM_NAO_FISCAL.CD_EMP				= FINAL.CD_EMP		
						AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL			= FINAL.CD_FILIAL	
						AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR			= FINAL.CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF		
						AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= FINAL.CD_RECTO_TEF		
			WHERE 
					PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP    = @CD_EMP 
			    AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = @CD_FILIAL
			  	AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR    = @CD_CTR
				AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF  = @CD_RECTO_TEF
				AND FINAL.CD_EMP IS NULL 
				AND CONCILIADOR.TPT_REGISTRO = 3 
				AND CONCILIADOR.CD_GRUPO NOT IN (141,142,143)
				AND NOT CONCILIADOR.ST_LOJA IN (90,91)
				AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
				/*INICIO CARTEIRAS DIGITAIS - NAO FISCAL*/
				INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												   ,CD_CTR_ID_QR_LINX
												)	
				select V.CD_EMP				AS CD_EMP				
									,V.CD_FILIAL				AS CD_FILIAL			
									,V.CD_CX					AS CD_CX				
									,V.NR_COO				AS NR_ECF				
									,V.DT_CUPOM				AS DT_VD
									, vlr_qr_linx as VLR_QR
									,C.ST_LOJA					    AS COD_SIT	
									,PDV_RECBTO_TEF.CD_ADM_CARTAO			    AS IDT_REDE			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_REDE			
									,PDV_RECBTO_TEF.COD_BANDEIRA			    AS IDT_PRODUTO			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_PRODUTO
									,0										    AS DESCR_TRN			
									,C.CD_BANDEIRA_LOJA				AS IDT_BANDEIRA		
									,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA	
									,PDV_RECBTO_TEF.QTDE_PARCELAS				AS NUM_PARCELAS		
									,''											AS CODIGO_RESP			
									,0											AS ESTADO_TRN			
									,''											AS DATA_LANC			
									,''											AS DATAFISCAL			
									,C.CD_AUTORIZACAO					AS COD_AUTORIZ			
									,V.ST_CUPOM				AS ST_VENDA			
				 					,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_RECBTO_TEF.NSU_SITEF))			AS NSU_SITEF			
									,1											AS TP_OP_AUTOMATICO	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,V.NR_COO 
									,C.IDT_TRANSACAO
									,C.CD_CTR	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,qr.CD_CTR_ID AS CD_CTR_ID_QR_LINX
				from CONCILIACAO_CARTOES_LINX_CONCILIADOR c
				inner join PDV_NSU_QR_LINX qr on c.cd_autorizacao COLLATE DATABASE_DEFAULT = qr.id_transaction COLLATE DATABASE_DEFAULT
												and c.cd_filial = qr.cd_filial
												and c.vlr_bruto_rede = qr.vlr_qr_linx
				inner JOIN PDV_CUPOM_NAO_FISCAL_PDV_NSU_QR_LINX  nsu on nsu.CD_CTR_ID = qr.CD_CTR_ID
				INNER JOIN PDV_CUPOM_NAO_FISCAL V ON V.CD_EMP = 1 AND V.CD_FILIAL = QR.CD_FILIAL AND nsu.CD_cTR = V.CD_CTR
				inner join PDV_CUPOM_NAO_FISCAL_TEF on
								V.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP
								AND V.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
								AND V.CD_CTR = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
				JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF
				LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON C.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA
				LEFT JOIN V_EQUALS_FINAL  FINAL ON v.CD_EMP		= FINAL.CD_EMP		
																AND v.CD_FILIAL	= FINAL.CD_FILIAL	
																AND v.CD_CX		= FINAL.CD_CX		
																AND v.NR_COO		= FINAL.NR_ECF		
							  WHERE 
							  PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP    = @CD_EMP 
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = @CD_FILIAL
			  					AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR    = @CD_CTR
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF  = @CD_RECTO_TEF
								AND FINAL.CD_EMP IS NULL 
								AND c.TPT_REGISTRO = 3 
								AND NOT c.ST_LOJA IN (90,91)
								AND c.CD_GRUPO NOT IN (141,142,143)
								AND v.ST_CUPOM = 0
								AND QR.NOME_CARTEIRA NOT LIKE '%PIX%'
				/*FIM CARTEIRAS DIGITAIS - NAO FISCAL*/
				/*INICIO PIX - NAO FISCAL*/
				INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												   ,CD_CTR_ID_QR_LINX
												)	
				select V.CD_EMP				AS CD_EMP				
									,V.CD_FILIAL				AS CD_FILIAL			
									,V.CD_CX					AS CD_CX				
									,V.NR_COO				AS NR_ECF				
									,V.DT_CUPOM				AS DT_VD
									, vlr_qr_linx as VLR_QR
									,C.ST_LOJA					    AS COD_SIT	
									,PDV_RECBTO_TEF.CD_ADM_CARTAO			    AS IDT_REDE			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_REDE			
									,PDV_RECBTO_TEF.COD_BANDEIRA			    AS IDT_PRODUTO			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_PRODUTO
									,0										    AS DESCR_TRN			
									,C.CD_BANDEIRA_LOJA				AS IDT_BANDEIRA		
									,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA	
									,PDV_RECBTO_TEF.QTDE_PARCELAS				AS NUM_PARCELAS		
									,''											AS CODIGO_RESP			
									,0											AS ESTADO_TRN			
									,''											AS DATA_LANC			
									,''											AS DATAFISCAL			
									,C.CD_AUTORIZACAO					AS COD_AUTORIZ			
									,V.ST_CUPOM				AS ST_VENDA			
				 					,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_RECBTO_TEF.NSU_SITEF))			AS NSU_SITEF			
									,1											AS TP_OP_AUTOMATICO	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,V.NR_COO 
									,C.IDT_TRANSACAO
									,C.CD_CTR	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,qr.CD_CTR_ID AS CD_CTR_ID_QR_LINX
				from CONCILIACAO_CARTOES_LINX_CONCILIADOR c
				inner join PDV_NSU_QR_LINX qr on c.NSU_REDE COLLATE DATABASE_DEFAULT = qr.id_payment COLLATE DATABASE_DEFAULT AND C.NSU_REDE <> '0'
												and c.cd_filial = qr.cd_filial
												and c.vlr_bruto_rede = qr.vlr_qr_linx
				inner JOIN PDV_CUPOM_NAO_FISCAL_PDV_NSU_QR_LINX  nsu on nsu.CD_CTR_ID = qr.CD_CTR_ID
				INNER JOIN PDV_CUPOM_NAO_FISCAL V ON V.CD_EMP = 1 AND V.CD_FILIAL = QR.CD_FILIAL AND nsu.CD_cTR = V.CD_CTR
				inner join PDV_CUPOM_NAO_FISCAL_TEF on
								V.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP
								AND V.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
								AND V.CD_CTR = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
				JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF
														AND PDV_RECBTO_TEF.VL_CARTAO = QR.VLR_QR_LINX /*iNCLUIDO EM 08/02 POR Problemas na Estrela*/
				LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON C.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA
				LEFT JOIN V_EQUALS_FINAL  FINAL ON v.CD_EMP		= FINAL.CD_EMP		
																AND v.CD_FILIAL	= FINAL.CD_FILIAL	
																AND v.CD_CX		= FINAL.CD_CX		
																AND v.NR_COO		= FINAL.NR_ECF		
							  WHERE 
							  PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP    = @CD_EMP 
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = @CD_FILIAL
			  					AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR    = @CD_CTR
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF  = @CD_RECTO_TEF
								AND FINAL.CD_EMP IS NULL 
								AND c.TPT_REGISTRO = 3 
								AND NOT c.ST_LOJA IN (90,91)
								AND c.CD_GRUPO NOT IN (141,142,143)
								AND v.ST_CUPOM = 0
								AND QR.NOME_CARTEIRA LIKE '%PIX%'
				/*FIM PIX - NAO FISCAL*/
			PRINT 'Atualizando IDT_TRANSACAO :'
			UPDATE PDV_CUPOM_NAO_FISCAL
			   SET IDT_TRANSACAO = CONCILIACAO_CARTOES_FINAL.IDT_TRANSACAO
			  FROM PDV_CUPOM_NAO_FISCAL
			       JOIN PDV_CUPOM_NAO_FISCAL_TEF ON PDV_CUPOM_NAO_FISCAL.CD_EMP    = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
												AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
												AND PDV_CUPOM_NAO_FISCAL.CD_CTR	   = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR 
			       JOIN CONCILIACAO_CARTOES_FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP	= CONCILIACAO_CARTOES_FINAL.CD_EMP		 
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= CONCILIACAO_CARTOES_FINAL.CD_FILIAL	
												 AND PDV_CUPOM_NAO_FISCAL.CD_CX		= CONCILIACAO_CARTOES_FINAL.CD_CX		
												 AND PDV_CUPOM_NAO_FISCAL.NR_COO	= CONCILIACAO_CARTOES_FINAL.NR_ECF	
			 WHERE PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= @CD_EMP 
			   AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= @CD_FILIAL
			   AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR			= @CD_CTR
			   AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= @CD_RECTO_TEF
			PRINT 'Removendo da pendencia.:'
			DELETE FROM PDV_CUPOM_NAO_FISCAL_TEF_PEND
			  FROM PDV_CUPOM_NAO_FISCAL
			       JOIN PDV_CUPOM_NAO_FISCAL_TEF_PEND ON PDV_CUPOM_NAO_FISCAL.NR_COO    = PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO   
												     AND PDV_CUPOM_NAO_FISCAL.CD_CTR	= PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR 
			       JOIN CONCILIACAO_CARTOES_FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP	= CONCILIACAO_CARTOES_FINAL.CD_EMP		 
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= CONCILIACAO_CARTOES_FINAL.CD_FILIAL	
												 AND PDV_CUPOM_NAO_FISCAL.CD_CX		= CONCILIACAO_CARTOES_FINAL.CD_CX		
												 AND PDV_CUPOM_NAO_FISCAL.NR_COO	= CONCILIACAO_CARTOES_FINAL.NR_ECF	
			 WHERE PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP			= @CD_EMP 
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL		= @CD_FILIAL
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR			= @CD_CTR
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_RECTO_TEF	= @CD_RECTO_TEF
	END
	ELSE
	BEGIN
	 		PRINT 'PROCESSANDO NAO FISCAL. 
			   CD_FILIAL.: ' + CONVERT(VARCHAR, @CD_FILIAL) + 
			   ' NR_COO.: '   + CONVERT(VARCHAR, @CD_VD)  + 
			   ' CD_CTR.: '   + CONVERT(VARCHAR, @CD_CTR);		
			INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												)	
		    SELECT 
					 PDV_CUPOM_NAO_FISCAL.CD_EMP				AS CD_EMP				
					,PDV_CUPOM_NAO_FISCAL.CD_FILIAL				AS CD_FILIAL			
					,PDV_CUPOM_NAO_FISCAL.CD_CX					AS CD_CX				
					,PDV_CUPOM_NAO_FISCAL.NR_COO				AS NR_ECF				
					,PDV_CUPOM_NAO_FISCAL.DT_CUPOM				AS DT_VD				
					,PDV_RECBTO_TEF.VL_CARTAO					AS VLR_VENDA			
					,CONCILIADOR.ST_LOJA					    AS COD_SIT				
					,PDV_RECBTO_TEF.CD_ADM_CARTAO			    AS IDT_REDE			
					,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_REDE			
					,PDV_RECBTO_TEF.COD_BANDEIRA			    AS IDT_PRODUTO			
					,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_PRODUTO		
					,0										    AS DESCR_TRN			
					,CONCILIADOR.CD_BANDEIRA_LOJA				AS IDT_BANDEIRA		
					,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA	
					,PDV_RECBTO_TEF.QTDE_PARCELAS				AS NUM_PARCELAS		
					,''											AS CODIGO_RESP			
					,0											AS ESTADO_TRN			
					,''											AS DATA_LANC			
					,''											AS DATAFISCAL			
					,CONCILIADOR.CD_AUTORIZACAO					AS COD_AUTORIZ			
					,PDV_CUPOM_NAO_FISCAL.ST_CUPOM				AS ST_VENDA			
				 	,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_RECBTO_TEF.NSU_SITEF))			AS NSU_SITEF			
					,1											AS TP_OP_AUTOMATICO	
					,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
					,PDV_CUPOM_NAO_FISCAL.NR_COO 
					,CONCILIADOR.IDT_TRANSACAO
					,CONCILIADOR.CD_CTR	
					,PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF
					,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
			  FROM PDV_CUPOM_NAO_FISCAL 
				    JOIN PDV_CUPOM_NAO_FISCAL_TEF ON PDV_CUPOM_NAO_FISCAL.CD_EMP    = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
												 AND PDV_CUPOM_NAO_FISCAL.CD_CTR	= PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
					JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
										AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
										AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF
					JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR CONCILIADOR ON 
							PDV_RECBTO_TEF.CD_FILIAL					= CONCILIADOR.CD_FILIAL
						AND (( CONVERT(VARCHAR,PDV_RECBTO_TEF.NSU_SITEF)	= CONVERT(VARCHAR,CONCILIADOR.NSU_REDE) AND CONCILIADOR.NSU_REDE <> '0') OR
						 PDV_RECBTO_TEF.NR_AUTORIZACAO	COLLATE database_Default	= CONCILIADOR.CD_AUTORIZACAO COLLATE database_Default)
						AND (PDV_RECBTO_TEF.QTDE_PARCELAS 				= CONCILIADOR.NR_PARCELAS_REDE)
					     AND (PDV_RECBTO_TEF.VL_CARTAO					= CONCILIADOR.VLR_BRUTO_REDE)
					LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON CONCILIADOR.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA 
					LEFT JOIN V_EQUALS_FINAL  FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP		= FINAL.CD_EMP		
												AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= FINAL.CD_FILIAL	
												AND PDV_CUPOM_NAO_FISCAL.CD_CX		= FINAL.CD_CX		
												AND PDV_CUPOM_NAO_FISCAL.NR_COO		= FINAL.NR_ECF		
			  WHERE PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP    = @CD_EMP 
			    AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = @CD_FILIAL
			  	AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR    = @CD_CTR
				AND PDV_CUPOM_NAO_FISCAL.NR_COO        = @CD_VD
				AND FINAL.CD_EMP IS NULL 
				AND CONCILIADOR.TPT_REGISTRO = 3 
				AND NOT CONCILIADOR.ST_LOJA IN (90,91)
				AND CONCILIADOR.CD_GRUPO NOT IN (141,142,143)
				AND PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
				/*INICIO CARTEIRAS DIGITAIS - NAO FISCAL*/
				INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												   ,CD_CTR_ID_QR_LINX
												)	
				select V.CD_EMP				AS CD_EMP				
									,V.CD_FILIAL				AS CD_FILIAL			
									,V.CD_CX					AS CD_CX				
									,V.NR_COO				AS NR_ECF				
									,V.DT_CUPOM				AS DT_VD
									, vlr_qr_linx as VLR_QR
									,C.ST_LOJA					    AS COD_SIT	
									,PDV_RECBTO_TEF.CD_ADM_CARTAO			    AS IDT_REDE			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_REDE			
									,PDV_RECBTO_TEF.COD_BANDEIRA			    AS IDT_PRODUTO			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_PRODUTO
									,0										    AS DESCR_TRN			
									,C.CD_BANDEIRA_LOJA				AS IDT_BANDEIRA		
									,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA	
									,PDV_RECBTO_TEF.QTDE_PARCELAS				AS NUM_PARCELAS		
									,''											AS CODIGO_RESP			
									,0											AS ESTADO_TRN			
									,''											AS DATA_LANC			
									,''											AS DATAFISCAL			
									,C.CD_AUTORIZACAO					AS COD_AUTORIZ			
									,V.ST_CUPOM				AS ST_VENDA			
				 					,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_RECBTO_TEF.NSU_SITEF))			AS NSU_SITEF			
									,1											AS TP_OP_AUTOMATICO	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,V.NR_COO 
									,C.IDT_TRANSACAO
									,C.CD_CTR	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,qr.CD_CTR_ID AS CD_CTR_ID_QR_LINX
				from CONCILIACAO_CARTOES_LINX_CONCILIADOR c
				inner join PDV_NSU_QR_LINX qr on c.cd_autorizacao COLLATE DATABASE_DEFAULT = qr.id_transaction COLLATE DATABASE_DEFAULT
												and c.cd_filial = qr.cd_filial
												and c.vlr_bruto_rede = qr.vlr_qr_linx
				inner JOIN PDV_CUPOM_NAO_FISCAL_PDV_NSU_QR_LINX  nsu on nsu.CD_CTR_ID = qr.CD_CTR_ID
				INNER JOIN PDV_CUPOM_NAO_FISCAL V ON V.CD_EMP = 1 AND V.CD_FILIAL = QR.CD_FILIAL AND nsu.CD_cTR = V.CD_CTR
				inner join PDV_CUPOM_NAO_FISCAL_TEF on
								V.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP
								AND V.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
								AND V.CD_CTR = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
				JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF
				LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON C.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA
				LEFT JOIN V_EQUALS_FINAL  FINAL ON v.CD_EMP		= FINAL.CD_EMP		
																AND v.CD_FILIAL	= FINAL.CD_FILIAL	
																AND v.CD_CX		= FINAL.CD_CX		
																AND v.NR_COO		= FINAL.NR_ECF		
							  WHERE PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP    = @CD_EMP 
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = @CD_FILIAL
			  					AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR    = @CD_CTR
								AND V.NR_COO        = @CD_VD
								AND FINAL.CD_EMP IS NULL 
								AND C.TPT_REGISTRO = 3 
								AND NOT C.ST_LOJA IN (90,91)
								AND C.CD_GRUPO NOT IN (141,142,143)
								AND V.ST_CUPOM = 0
								AND QR.NOME_CARTEIRA NOT LIKE '%PIX%'
				/*FIM CARTEIRAS DIGITAIS - NAO FISCAL*/
				/*INICIO PIX - NAO FISCAL*/
				INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
												   ,CD_RECTO_TEF
												   ,CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF
												   ,CD_CTR_ID_QR_LINX
												)	
				select V.CD_EMP				AS CD_EMP				
									,V.CD_FILIAL				AS CD_FILIAL			
									,V.CD_CX					AS CD_CX				
									,V.NR_COO				AS NR_ECF				
									,V.DT_CUPOM				AS DT_VD
									, vlr_qr_linx as VLR_QR
									,C.ST_LOJA					    AS COD_SIT	
									,PDV_RECBTO_TEF.CD_ADM_CARTAO			    AS IDT_REDE			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_REDE			
									,PDV_RECBTO_TEF.COD_BANDEIRA			    AS IDT_PRODUTO			
									,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_PRODUTO
									,0										    AS DESCR_TRN			
									,C.CD_BANDEIRA_LOJA				AS IDT_BANDEIRA		
									,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIO DE BANDEIRA')		AS DESCR_BANDEIRA	
									,PDV_RECBTO_TEF.QTDE_PARCELAS				AS NUM_PARCELAS		
									,''											AS CODIGO_RESP			
									,0											AS ESTADO_TRN			
									,''											AS DATA_LANC			
									,''											AS DATAFISCAL			
									,C.CD_AUTORIZACAO					AS COD_AUTORIZ			
									,V.ST_CUPOM				AS ST_VENDA			
				 					,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_RECBTO_TEF.NSU_SITEF))			AS NSU_SITEF			
									,1											AS TP_OP_AUTOMATICO	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,V.NR_COO 
									,C.IDT_TRANSACAO
									,C.CD_CTR	
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF
									,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
									,qr.CD_CTR_ID AS CD_CTR_ID_QR_LINX
				from CONCILIACAO_CARTOES_LINX_CONCILIADOR c
				inner join PDV_NSU_QR_LINX qr on c.NSU_REDE COLLATE DATABASE_DEFAULT = qr.id_payment COLLATE DATABASE_DEFAULT AND C.NSU_REDE <> '0'
												and c.cd_filial = qr.cd_filial
												and c.vlr_bruto_rede = qr.vlr_qr_linx
				inner JOIN PDV_CUPOM_NAO_FISCAL_PDV_NSU_QR_LINX  nsu on nsu.CD_CTR_ID = qr.CD_CTR_ID
				INNER JOIN PDV_CUPOM_NAO_FISCAL V ON V.CD_EMP = 1 AND V.CD_FILIAL = QR.CD_FILIAL AND nsu.CD_cTR = V.CD_CTR
				inner join PDV_CUPOM_NAO_FISCAL_TEF on
								V.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP
								AND V.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
								AND V.CD_CTR = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
				JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
														AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF
														AND PDV_RECBTO_TEF.VL_CARTAO = QR.VLR_QR_LINX /*iNCLUIDO EM 08/02 POR Problemas na Estrela*/
				LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON C.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA
				LEFT JOIN V_EQUALS_FINAL  FINAL ON v.CD_EMP		= FINAL.CD_EMP		
																AND v.CD_FILIAL	= FINAL.CD_FILIAL	
																AND v.CD_CX		= FINAL.CD_CX		
																AND v.NR_COO		= FINAL.NR_ECF		
							  WHERE PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP    = @CD_EMP 
								AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = @CD_FILIAL
			  					AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR    = @CD_CTR
								AND V.NR_COO        = @CD_VD
								AND FINAL.CD_EMP IS NULL 
								AND C.TPT_REGISTRO = 3 
								AND NOT C.ST_LOJA IN (90,91)
								AND C.CD_GRUPO NOT IN (141,142,143)
								AND V.ST_CUPOM = 0
								AND QR.NOME_CARTEIRA LIKE '%PIX%'
				/*FIM PIX - NAO FISCAL*/
			PRINT 'Atualizando IDT_TRANSACAO :'
			UPDATE PDV_CUPOM_NAO_FISCAL
			   SET IDT_TRANSACAO = CONCILIACAO_CARTOES_FINAL.IDT_TRANSACAO
			  FROM PDV_CUPOM_NAO_FISCAL
			       JOIN PDV_CUPOM_NAO_FISCAL_TEF ON PDV_CUPOM_NAO_FISCAL.CD_EMP    = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
												AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
												AND PDV_CUPOM_NAO_FISCAL.CD_CTR	   = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR 
			       JOIN CONCILIACAO_CARTOES_FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP	= CONCILIACAO_CARTOES_FINAL.CD_EMP		 
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= CONCILIACAO_CARTOES_FINAL.CD_FILIAL	
												 AND PDV_CUPOM_NAO_FISCAL.CD_CX		= CONCILIACAO_CARTOES_FINAL.CD_CX		
												 AND PDV_CUPOM_NAO_FISCAL.NR_COO	= CONCILIACAO_CARTOES_FINAL.NR_ECF	
			 WHERE PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP		= @CD_EMP 
			   AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL	= @CD_FILIAL
			   AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR		= @CD_CTR
			   AND PDV_CUPOM_NAO_FISCAL.NR_COO			= @CD_VD
			PRINT 'Removendo da pendencia.:'
			DELETE FROM PDV_CUPOM_NAO_FISCAL_TEF_PEND
			  FROM PDV_CUPOM_NAO_FISCAL
			       JOIN PDV_CUPOM_NAO_FISCAL_TEF_PEND ON PDV_CUPOM_NAO_FISCAL.NR_COO    = PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO   
												     AND PDV_CUPOM_NAO_FISCAL.CD_CTR	= PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR 
			       JOIN CONCILIACAO_CARTOES_FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP	= CONCILIACAO_CARTOES_FINAL.CD_EMP		 
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= CONCILIACAO_CARTOES_FINAL.CD_FILIAL	
												 AND PDV_CUPOM_NAO_FISCAL.CD_CX		= CONCILIACAO_CARTOES_FINAL.CD_CX		
												 AND PDV_CUPOM_NAO_FISCAL.NR_COO	= CONCILIACAO_CARTOES_FINAL.NR_ECF	
			 WHERE PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP		= @CD_EMP 
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL	= @CD_FILIAL
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR		= @CD_CTR
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO		= @CD_VD
 	ENd 			
 	 FETCH NEXT FROM CONCILIADORLINX INTO  @CD_EMP, @CD_FILIAL, @CD_VD, @CD_CTR, @CD_RECTO_TEF, @CD_CTR_PDV_CUPOM_NAO_FISCAL_TEF,  @TIPO;
	 END;
	 CLOSE CONCILIADORLINX;
	 DEALLOCATE CONCILIADORLINX;
	PRINT 'FIM P_CONCILIADOR_LINX_CARTAO_FILIAL!'

	/*Excluindo vendas retroativas conciliadas, DEVOLVIDAS TOTAL, COM NCC 2,3,5. Solicitado no chamado FARMAGOI-48262*/

	DELETE FINAL
	FROM CONCILIACAO_CARTOES_FINAL FINAL
	WHERE EXISTS (SELECT 1 
								FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP DEV
								INNER JOIN PDV_VD_DEV_NCC NCC ON DEV.CD_EMP = NCC.CD_EMP
								AND DEV.CD_FILIAL = NCC.CD_FILIAL
								AND DEV.CD_CTR_NCC = NCC.CD_CTR_NCC
								WHERE DEV.CD_FILIAL = FINAL.CD_FILIAL
									  AND DEV.CD_VD = FINAL.CD_VD
									  AND STS_NCC IN (2,3,5)
									  AND NOT EXISTS (SELECT CD_EMP 
													  FROM RC_DEB_PDV_VD_DEV_NCC DEB
													  WHERE DEV.CD_EMP = DEB.CD_EMP AND DEV.CD_FILIAL = DEB.CD_FILIAL
													  AND DEV.CD_CTR_NCC = DEB.CD_CTR_NCC)
								AND ((SELECT COUNT(DISTINCT V_IT.CD_PROD) 
									FROM V_PDV_VD_IT V_IT 
									WHERE V_IT.CD_VD = DEV.CD_FILIAL 
									AND V_IT.CD_FILIAL = DEV.CD_FILIAL
									AND V_IT.CD_EMP = 1) = (SELECT COUNT(DISTINCT IMP2.CD_PROD)
																			 FROM PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP IMP2
																			 WHERE IMP2.CD_VD = DEV.CD_FILIAL
																			 AND IMP2.CD_FILIAL = DEV.CD_FILIAL)) /*DEVOLUÇÃO TOTAL*/
					) /*FARMAGOI-48262*/
	AND FINAL.TP_OP_AUTOMATICO = 1

